﻿#pragma   once

#include  "Resource.h"
#include  "Guids.hpp"
#include  "MenuItem.hpp"
#include  "MenuHandlerBase.hpp"

class ATL_NO_VTABLE CDropMenuHandler :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<CDropMenuHandler, &CLSID_DropMenuHandler>,
  public IShellExtInit,
  public IContextMenu3,
  private CMenuHandlerBase
{
public:
  CDropMenuHandler();
  ~CDropMenuHandler();

DECLARE_REGISTRY_RESOURCEID(IDR_DROPMENUHANDLER)

DECLARE_NOT_AGGREGATABLE(CDropMenuHandler)

BEGIN_COM_MAP(CDropMenuHandler)
  COM_INTERFACE_ENTRY(IShellExtInit)
  COM_INTERFACE_ENTRY(IContextMenu)
  COM_INTERFACE_ENTRY(IContextMenu2)
  COM_INTERFACE_ENTRY(IContextMenu3)
END_COM_MAP()

  DECLARE_PROTECT_FINAL_CONSTRUCT()

  HRESULT FinalConstruct() { return S_OK; }
  void    FinalRelease() { }

public:

  // IShellExtInit
  STDMETHODIMP Initialize(__in PCIDLIST_ABSOLUTE pidlFolder, __in IDataObject *pdtobj, __in HKEY hkeyProgID);

  // IContextMenu
  STDMETHODIMP QueryContextMenu(__in HMENU hmenu, __in UINT indexMenu, __in UINT idCmdFirst, __in UINT idCmdLast, __in UINT uFlags);
  STDMETHODIMP InvokeCommand(__in CMINVOKECOMMANDINFO *pici);
  STDMETHODIMP GetCommandString(__in UINT_PTR idCmd, __in UINT uType, __reserved UINT *pReserved, __out LPSTR pszName, __in UINT cchMax);

  // IContextMenu2
  STDMETHODIMP HandleMenuMsg(__in UINT uMsg, __in WPARAM wParam, __in LPARAM lParam);

  // IContextMenu3
  STDMETHODIMP HandleMenuMsg2(__in UINT uMsg, __in WPARAM wParam, __in LPARAM lParam, __out LRESULT *plResult);

protected:
  virtual UINT MenuIdToIconID(UINT uID);

private:

  UINT                  m_idCmdFirst;
  std::vector<MenuItem> m_MenuItems;
  szstring              m_TargetDir;
};

OBJECT_ENTRY_AUTO(CLSID_DropMenuHandler, CDropMenuHandler)
